function data_output = OFDM_receiver_new(channel_output,N, BlockLength, L)

M = length(channel_output);
block_length = N+L;
data_output = [];

for k = 1:block_length:M-block_length+1 %-block_length

    % Remove cyclic prefix & make blocks
    
    parallel_symbols = channel_output(k+L:k+block_length-1);
    
    % Take FFT of each block seperatly
    
    fft_output = fft(parallel_symbols,N);
    fft_output = fft_output(1:BlockLength);
    
    % Combine all blocks, parallel to serial
        
    data_output = [data_output, fft_output];

end

end